// fragment shader for planar yuv with 3 planes (420,422,444) and 1 byte per component little endian
// vec4 cspace: cspace.r - chroma width divider  (depending on 420/422/444 type) 2 for 420, 1 for 444
//              cspace.g - chroma height divider (depending on 420/422/444 type) 2 for 420, 1 for 444

uniform sampler2DRect Ytex;
uniform sampler2DRect Utex,Vtex;
uniform vec3 offset;
// RGB coefficients
uniform vec3 Rcoeff;
uniform vec3 Gcoeff;
uniform vec3 Bcoeff;
uniform vec4 cspace;
uniform    float  imgHeight;
void main(void) {
    vec3 YUV, RGB;
    float nx,ny;
    nx=0.5 + gl_TexCoord[0].x;
    ny=imgHeight-gl_TexCoord[0].y;
    YUV.x=texture2DRect(Ytex,vec2(nx,ny)).r;
    YUV.y=texture2DRect(Utex,vec2(nx/cspace.r,ny/cspace.g)).r;
    YUV.z=texture2DRect(Vtex,vec2(nx/cspace.r,ny/cspace.g)).r;
    YUV += offset;
    RGB.r = dot(YUV, Rcoeff);
    RGB.g = dot(YUV, Gcoeff);
    RGB.b = dot(YUV, Bcoeff);

    gl_FragColor = vec4(RGB, 1.0);
}
