// fragment shader for planar yuv with 3 planes (420,422,444) and 2 byte per component little endian
// vec4 cspace: cspace.r - chroma width divider  (depending on 420/422/444 type) 2 for 420, 1 for 444
//              cspace.g - chroma height divider (depending on 420/422/444 type) 2 for 420, 1 for 444
//              cspace.b - low byte divider (depending on bitdepth specifies shifts number for less significant byte) 64 for 10 bits
//              cspace.a - hight byte multiplier (depending on bitdepth specifies shifts number for less significant byte)  4 for 10 bits
// - because normzlized values passed as two separates bytes of single two-byte

uniform sampler2DRect Ytex;
uniform sampler2DRect Utex,Vtex;
uniform vec3 offset;
uniform vec4 cspace;

uniform vec3 Rcoeff;
uniform vec3 Gcoeff;
uniform vec3 Bcoeff;
uniform    float  imgHeight;
void main(void) {
    vec3 YUV, RGB;
    float nx,ny,nxuv,nyuv;
    nx=0.5 + gl_TexCoord[0].x;
    ny=imgHeight - gl_TexCoord[0].y;
    nxuv=nx / cspace.r;
    nyuv=ny / cspace.g;
    YUV.x=texture2DRect(Ytex,vec2(nx,ny)).r / cspace.b     + texture2DRect(Ytex,vec2(nx,ny)).g * cspace.a;
    YUV.y=texture2DRect(Utex,vec2(nxuv,nyuv)).r / cspace.b +  texture2DRect(Utex,vec2(nxuv,nyuv)).g * cspace.a;
    YUV.z=texture2DRect(Vtex,vec2(nxuv,nyuv)).r / cspace.b +  texture2DRect(Vtex,vec2(nxuv,nyuv)).g * cspace.a;

    YUV += offset;
    RGB.r = dot(YUV, Rcoeff);
    RGB.g = dot(YUV, Gcoeff);
    RGB.b = dot(YUV, Bcoeff);

    gl_FragColor = vec4(RGB, 1.0);
}
